<?php
declare(strict_types=1);
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Out Of Stock Notifications Hyva Compatibility
 */

namespace Amasty\OutofstockHyvaCompatibility\ViewModel;

use Magento\Framework\View\Element\Block\ArgumentInterface;
use Hyva\Theme\Model\ViewModelRegistry;
use Hyva\GraphqlViewModel\ViewModel\GraphqlViewModel;

/**
 * GraphQl queries for subscriptions
 */
class SubscribeQuery implements ArgumentInterface
{
    /**
     * @var ViewModelRegistry
     */
    private $viewModels;

    /**
     * Constructor
     *
     * @param ViewModelRegistry $viewModels
     */
    public function __construct(
        ViewModelRegistry $viewModels
    ) {
        $this->viewModels = $viewModels;
    }

    /**
     * Returns GraphQl query for price subscription on product page
     *
     * @return string
     */
    public function mutationPriceSubscription(): string
    {
        $viewModelGraphQl = $this->viewModels->require(GraphqlViewModel::class);

        return $viewModelGraphQl->query(
            'amxnotif_price_subsciption',
            'mutation AmxnotifPriceSubscribe($input: AmxnotifSubscribeInput) {
                        AmxnotifPriceSubscribe(input: $input) {
                            response_message
                        }
                   }'
        );
    }

    /**
     * Returns GraphQl query for stock subscription on product page
     *
     * @return string
     */
    public function mutationStockSubscription(): string
    {
        $viewModelGraphQl = $this->viewModels->require(GraphqlViewModel::class);

        return $viewModelGraphQl->query(
            'amxnotif_stock_subsciption',
            'mutation AmxnotifStockSubscribe($input: AmxnotifSubscribeInput) {
                        AmxnotifStockSubscribe(input: $input) {
                            response_message
                        }
                   }'
        );
    }
}
