<?php

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Out Of Stock Notifications Hyva Compatibility
 */

declare(strict_types=1);

namespace Amasty\OutofstockHyvaCompatibility\ViewModel;

use Magento\Framework\App\ActionInterface;
use Magento\Framework\View\Element\Block\ArgumentInterface;
use Magento\Framework\Url\Helper\Data as UrlHelper;
use Magento\Framework\UrlInterface;

/**
 * Product alert url view model
 */
class ProductAlertUrl implements ArgumentInterface
{
    /**
     * @var string
     */
    public const URL_TYPE_PRICE = 'price';

    /**
     * @var UrlInterface
     */
    private $url;

    /**
     * @var UrlHelper
     */
    private $urlHelper;

    /**
     * @param UrlInterface $url
     * @param UrlHelper $urlHelper
     */
    public function __construct(UrlInterface $url, UrlHelper $urlHelper)
    {
        $this->url = $url;
        $this->urlHelper = $urlHelper;
    }

    /**
     * Build price alert url
     *
     * @param int $productId
     * @param string $type
     * @param int|null $parentId
     *
     * @return string
     */
    public function getPriceAlertUrl(int $productId, string $type, ?int $parentId = null): string
    {
        return $this->url->getUrl('xnotif/email/' . $type, [
            'product_id' => $productId,
            ActionInterface::PARAM_NAME_URL_ENCODED => $this->urlHelper->getEncodedUrl(),
            'parent_id' => $parentId
        ]);
    }
}
