<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Out Of Stock Notifications Hyva Compatibility
 */

namespace Amasty\OutofstockHyvaCompatibility\Plugin\ViewModel;

use Amasty\Xnotif\Helper\Config as ConfigProvider;
use Hyva\Theme\Service\CurrentTheme;
use Hyva\Theme\ViewModel\ProductListItem as ListItem;
use Magento\Catalog\Model\Product;
use Magento\Framework\View\Element\Template;
use Magento\Framework\View\LayoutFactory;

class ProductListItemPlugin
{
    /**
     * @var CurrentTheme
     */
    private $currentTheme;

    /**
     * @var ConfigProvider
     */
    private $configProvider;

    /** @var LayoutFactory  */
    private $layoutFactory;

    /**
     * @param ConfigProvider $configProvider
     * @param CurrentTheme $currentTheme
     * @param LayoutFactory $layoutFactory
     */
    public function __construct(
        ConfigProvider $configProvider,
        CurrentTheme $currentTheme,
        LayoutFactory $layoutFactory
    ) {
        $this->configProvider = $configProvider;
        $this->currentTheme = $currentTheme;
        $this->layoutFactory = $layoutFactory;
    }

    /**
     * Сreate SubscribeMixinBlock
     *
     * @return Template
     */
    private function getSubscribeBlockMixin(): Template
    {
        return $this->layoutFactory
            ->create()
            ->createBlock(Template::class)
            ->setTemplate('Amasty_OutofstockHyvaCompatibility::js/category-subscribe-mixin.phtml');
    }

    /**
     * Render subscribe block after price
     *
     * @param ListItem $subject
     * @param string $html
     * @param Product $product
     * @return string
     */
    public function afterGetProductPriceHtml(
        ListItem $subject,
        string $html,
        Product $product
    ): string {
        if ($this->isEnabledOnCategory() && $this->currentTheme->isHyva()) {
            $subscribeBlock = $this->getSubscribeBlockMixin()->setData('productId', $product->getId())->toHtml();

            $html .= $subscribeBlock;
        }

        return $html;
    }

    /**
     * Check if module is enabled on category page
     *
     * @return bool
     */
    protected function isEnabledOnCategory(): bool
    {
        return $this->configProvider->isCategorySubscribeEnabled();
    }
}
