<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Out Of Stock Notifications Hyva Compatibility
 */

declare(strict_types=1);

namespace Amasty\OutofstockHyvaCompatibility\Plugin;

use Hyva\Theme\Service\CurrentTheme;
use Magento\Catalog\Block\Product\View;
use Magento\ConfigurableProduct\Model\Product\Type\Configurable;
use Magento\Framework\Exception\LocalizedException;
use Amasty\OutofstockHyvaCompatibility\Model\ConfigProvider;

class DisplayOptions
{
    /** @var CurrentTheme  */
    private $currentTheme;

    /** @var ConfigProvider  */
    private $configProvider;

    /**
     * Display Options constructor.
     *
     * @param CurrentTheme $currentTheme
     * @param ConfigProvider $configProvider
     */
    public function __construct(
        CurrentTheme $currentTheme,
        ConfigProvider $configProvider
    ) {
        $this->currentTheme = $currentTheme;
        $this->configProvider = $configProvider;
    }

    /**
     * Add the Amasty Options block to the product view page.
     *
     * @param View $subject
     * @param string $result
     * @return string
     * @throws LocalizedException
     */
    public function afterToHtml(View $subject, string $result): string
    {
        $product = $subject->getProduct();
        if (!$product
            || !$this->currentTheme->isHyva()
            || $product->getTypeId() !== Configurable::TYPE_CODE
        ) {
            return $result;
        }

        $cacheIsSalableFlag = $product->getIsSalable();

        // set flag to display swatches
        if ($this->configProvider->isShowOutOfStockOnly() && !$cacheIsSalableFlag) {
            $product->setData('salable', true);
        }

        if ($subject->getNameInLayout() !== 'product.info.form') {
            return $result;
        }

        // reset flag to avoid issues with other blocks
        if ($this->configProvider->isShowOutOfStockOnly()) {
            $product->setData('salable', $cacheIsSalableFlag);
        }

        $result .= $subject->getLayout()->getBlock('productalert.stock.amasty.options')->toHtml();

        return $result;
    }
}
