<?php

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Out Of Stock Notifications Hyva Compatibility
 */

declare(strict_types=1);

namespace Amasty\OutofstockHyvaCompatibility\Model;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Store\Model\ScopeInterface;

class ConfigProvider
{
    /**
     * @var string
     */
    private const XML_PATH_SHOW_OUT_OF_STOCK_ONLY = 'amxnotif/general/show_out_of_stock_only';

    /**
     * @var ScopeConfigInterface
     */
    private $config;

    /**
     * @param ScopeConfigInterface $scopeConfig
     */
    public function __construct(ScopeConfigInterface $scopeConfig)
    {
        $this->config = $scopeConfig;
    }

    /**
     * Check if show out of stock properties only
     *
     * @return bool
     */
    public function isShowOutOfStockOnly(): bool
    {
        return $this->config->isSetFlag(
            self::XML_PATH_SHOW_OUT_OF_STOCK_ONLY,
            ScopeInterface::SCOPE_STORE
        );
    }
}
