<?php

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Out Of Stock Notifications Hyva Compatibility
 */

declare(strict_types=1);

namespace Amasty\OutofstockHyvaCompatibility\Block\Product\View\Type\Grouped;

use Magento\GroupedProduct\Block\Product\View\Type\Grouped;

class Options extends Grouped
{
    /**
     * Render sub products block if grouped product is out of stock
     *
     * Div wrapper - workaround to avoid hyva js error with product_addtocart_form selector
     *
     * @return string
     */
    public function toHtml(): string
    {
        if ($this->getProduct()->isSaleable()) {
            return '';
        }

        return "<div id='product_addtocart_form'>" . parent::toHtml() . "</div>";
    }
}
