<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Out of stock Notifications GraphQL for Magento 2 (System)
 */

namespace Amasty\OsnGraphql\Test\GraphQl;

use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\Framework\GraphQl\Query\Uid;
use Magento\Integration\Api\CustomerTokenServiceInterface;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\TestFramework\TestCase\GraphQlAbstract;

class AmxnotifPriceSubscribeTest extends GraphQlAbstract
{
    public const CUSTOMER_NAME = 'customer@example.com';
    public const MAIN_QUERY_KEY = 'AmxnotifPriceSubscribe';
    public const RESPONSE_KEY = 'response_message';

    /**
     * @var Uid
     */
    private $idEncoder;

    /**
     * @var ProductRepositoryInterface
     */
    private $productRepository;

    protected function setUp(): void
    {
        parent::setUp();

        $objectManager = Bootstrap::getObjectManager();
        $this->idEncoder = $objectManager->create(Uid::class);
        $this->productRepository = $objectManager->get(ProductRepositoryInterface::class);
    }

    /**
     * @group amasty_osn
     *
     * @magentoApiDataFixture Magento/GraphQl/Catalog/_files/simple_product.php
     */
    public function testAmxnotifPriceSubscribe()
    {
        $product = $this->productRepository->get('simple_product');
        $productId = $product->getId();
        $productUid = $this->idEncoder->encode((string)$productId);

        $variables = [
            'email' => self::CUSTOMER_NAME,
            'gdprAgreement' => false,
            'productId' => $productId,
            'productUid' => $productUid
        ];
        $query = $this->getQuery();
        $response = $this->graphQlMutation($query, $variables);
        $responseSecondTime = $this->graphQlMutation($query, $variables);

        $this->assertArrayHasKey(self::MAIN_QUERY_KEY, $response);
        $this->assertArrayHasKey(self::RESPONSE_KEY, $response[self::MAIN_QUERY_KEY]);
        $this->assertEquals(
            'Alert subscription has been saved.',
            $response[self::MAIN_QUERY_KEY][ self::RESPONSE_KEY]
        );

        $this->assertArrayHasKey(self::MAIN_QUERY_KEY, $responseSecondTime);
        $this->assertArrayHasKey(self::RESPONSE_KEY, $responseSecondTime[self::MAIN_QUERY_KEY]);
        $this->assertEquals(
            'Thank you! You are already subscribed to this product.',
            $responseSecondTime[self::MAIN_QUERY_KEY][ self::RESPONSE_KEY]
        );
    }

    /**
     * @return string
     */
    private function getQuery(): string
    {
        return <<<'MUTATION'
mutation AmxnotifPrice(
  $email: String,
  $gdprAgreement: Boolean,
  $productId: Int,
  $productUid: String
){
  AmxnotifPriceSubscribe(
    input: {
      email:$email
      gdpr_agreement:$gdprAgreement
      product_id:$productId
      product_uid:$productUid
    }
  ) {
     response_message
  }
}
MUTATION;
    }
}
