<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Order Attributes GraphQl for Magento 2
 */

namespace Amasty\OrderattrGraphql\Plugin\Sales\Model\OrderRepository;

use Amasty\Orderattr\Model\Value\Metadata\Form;
use Amasty\Orderattr\Model\Value\Metadata\FormFactory;
use Magento\Framework\GraphQl\Exception\GraphQlInputException;
use Magento\Sales\Api\Data\OrderInterface;
use Magento\Sales\Model\OrderRepository;

class ValidateAttributes
{
    /**
     * @var FormFactory
     */
    private $metadataFormFactory;

    public function __construct(
        FormFactory $metadataFormFactory
    ) {
        $this->metadataFormFactory = $metadataFormFactory;
    }

    /**
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function beforeSave(OrderRepository $subject, OrderInterface $entity): array
    {
        $form = $this->createEntityForm($entity);
        $attributesData = $data = [];
        if ($entity->getExtensionAttributes()) {
            $attributesData = $entity->getExtensionAttributes()->getAmastyOrderAttributes() ?? [];
        }

        foreach ($attributesData as $attribute) {
            $data[$attribute->getAttributeCode()] = $attribute->getValue();
        }

        $errors = $form->validateData($data);
        if (is_array($errors)) {
            throw new GraphQlInputException(__('Order Attributes error: ' . implode($errors)));
        }

        return [$entity];
    }

    private function createEntityForm(OrderInterface $order): Form
    {
        /** @var Form $formProcessor */
        $formProcessor = $this->metadataFormFactory->create();
        $formProcessor->setFormCode('amasty_checkout')
            ->setEntity($order)
            ->setStore($order->getStoreId())
            ->setCustomerGroupId($order->getCustomerGroupId())
            ->setShippingMethod($order->getShippingMethod())
            ->setProductIds($this->getProductIds($order));

        return $formProcessor;
    }

    private function getProductIds(OrderInterface $order): array
    {
        $result = [];

        foreach ($order->getItems() as $item) {
            $result[] = $item->getProductId();
        }

        return $result;
    }
}
