<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Order Attributes GraphQl for Magento 2
 */

namespace Amasty\OrderattrGraphql\Model\Resolver;

use Amasty\Orderattr\Model\ResourceModel\Attribute\Relation\RelationDetails\CollectionFactory;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Query\Resolver\ContextInterface;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;

class AttributesRelations implements ResolverInterface
{
    /**
     * @var CollectionFactory
     */
    private $relationsCollectionFactory;

    public function __construct(
        CollectionFactory $relationsCollectionFactory
    ) {
        $this->relationsCollectionFactory = $relationsCollectionFactory;
    }

    /**
     * @param Field $field
     * @param ContextInterface $context
     * @param ResolveInfo $info
     * @param array|null $value
     * @param array|null $args
     * @return array
     */
    public function resolve(Field $field, $context, ResolveInfo $info, array $value = null, array $args = null)
    {
        $result = [];
        $collection = $this->relationsCollectionFactory->create();
        foreach ($collection->getItems() as $relationEntity) {
            $result[] = [
                'relation_id' => $relationEntity->getRelationId(),
                'attribute_id' => $relationEntity->getAttributeId(),
                'option_id' => $relationEntity->getOptionId(),
                'dependent_attribute_id' => $relationEntity->getDependentAttributeId()
            ];
        }

        return $result;
    }
}
