<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
 * @package Page Speed Optimizer Premium Functionality for Magento 2 (System)
 */

namespace Amasty\OptimizerPremiumFunctionality\Plugin;

use Amasty\OptimizerPremiumFunctionality\Model\PageSpeedOptimizerConfigProvider as ConfigProvider;
use Amasty\PageSpeedTools\Model\DeviceDetect;
use Magento\Framework\View\Asset\Config;

class ExcludePageFromMergeBundleJs
{
    /**
     * @var ConfigProvider
     */
    private $configProvider;
    /**
     * @var DeviceDetect
     */
    private $deviceDetect;

    public function __construct(
        ConfigProvider $configProvider,
        DeviceDetect $deviceDetect
    ) {
        $this->configProvider = $configProvider;
        $this->deviceDetect = $deviceDetect;
    }

    public function aroundIsMergeJsFiles(Config $subject, \Closure $proceed)
    {
        if ($this->isNeedToSkipByDeviceType()) {
            return false;
        }

        return $proceed();
    }

    public function aroundIsBundlingJsFiles(Config $subject, \Closure $proceed)
    {
        if ($this->isNeedToSkipByDeviceType()) {
            return false;
        }

        return $proceed();
    }

    public function isNeedToSkipByDeviceType(): bool
    {
        $disabledDeviceTypes = $this->configProvider->getDisabledDeviceTypes();
        $device = $this->deviceDetect->getDeviceType();

        return in_array($device, $disabledDeviceTypes);
    }
}
