<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
 * @package Page Speed Optimizer Premium Functionality for Magento 2 (System)
 */

namespace Amasty\OptimizerPremiumFunctionality\Plugin\Catalog\Model;

use Amasty\ImageOptimizer\Model\Image\ImageSettingGetter;
use Amasty\ImageOptimizer\Model\ImageProcessor;
use Amasty\ImageOptimizer\Model\Queue\ImageQueueService;
use Amasty\OptimizerPremiumFunctionality\Model\Constants;
use Amasty\OptimizerPremiumFunctionality\Model\ImageOptimizerConfigProvider as ConfigProvider;
use Magento\Catalog\Model\ImageUploader;

class ImageUploaderPlugin
{
    /**
     * @var ConfigProvider
     */
    private $configProvider;

    /**
     * @var ImageProcessor
     */
    private $imageProcessor;

    /**
     * @var ImageQueueService
     */
    private $imageQueueService;

    /**
     * @var ImageSettingGetter
     */
    private $imageSettingGetter;

    public function __construct(
        ConfigProvider $configProvider,
        ImageProcessor $imageProcessor,
        ImageQueueService $imageQueueService,
        ImageSettingGetter $imageSettingGetter
    ) {
        $this->configProvider = $configProvider;
        $this->imageProcessor = $imageProcessor;
        $this->imageQueueService = $imageQueueService;
        $this->imageSettingGetter = $imageSettingGetter;
    }

    public function afterMoveFileFromTmp(ImageUploader $subject, string $imagePath, string $initialImageName): string
    {
        if (!$this->configProvider->isOptimizeImagesByCron()
            || ($imageSetting = $this->imageSettingGetter->getSettingByImgPath($imagePath)) === null
            || !$imageSetting->isAutomaticOptimization()
        ) {
            return $imagePath;
        }
        if ($queueImage = $this->imageProcessor->prepareQueue($imagePath, $imageSetting)) {
            $queueImage->setQueueType(Constants::CRON_QUEUE);
            $this->imageQueueService->addToQueue($queueImage);
        }

        return $imagePath;
    }
}
