<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
 * @package Page Speed Optimizer Premium Functionality for Magento 2 (System)
 */

namespace Amasty\OptimizerPremiumFunctionality\Model;

use Amasty\PageSpeedOptimizer\Model\ConfigProvider;

class PageSpeedOptimizerConfigProvider extends ConfigProvider
{
    public const DISABLED_DEVICE_TYPES = 'javascript/disabled_device_types';

    public function getDisabledDeviceTypes(): array
    {
        $disabledTypes = (string)$this->getValue(self::DISABLED_DEVICE_TYPES);

        return array_filter(explode(',', $disabledTypes));
    }
}
