<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
 * @package Page Speed Optimizer Premium Functionality for Magento 2 (System)
 */

namespace Amasty\OptimizerPremiumFunctionality\Model\OptionSource;

use Amasty\PageSpeedTools\Model\OptionSource\ToOptionArrayTrait;
use Magento\Framework\Data\OptionSourceInterface;

class OptimizationType implements OptionSourceInterface
{
    public const IMMEDIATELY = 'immediately';
    public const CRON = 'cron';

    use ToOptionArrayTrait;

    /**
     * Get options in "key-value" format
     *
     * @return array
     */
    public function toArray(): array
    {
        return [
            self::IMMEDIATELY => __('Immediately after Uploading'),
            self::CRON => __('By Cron'),
        ];
    }
}
