<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
 * @package Page Speed Optimizer Premium Functionality for Magento 2 (System)
 */

namespace Amasty\OptimizerPremiumFunctionality\Model;

use Amasty\ImageOptimizer\Model\ConfigProvider;
use Amasty\OptimizerPremiumFunctionality\Model\OptionSource\OptimizationType;

class ImageOptimizerConfigProvider extends ConfigProvider
{
    public const OPTIMIZE_TYPE = 'images/optimization_type';

    public function isAutomaticallyOptimizeImages(): bool
    {
        return $this->isSetFlag(self::OPTIMIZE_AUTOMATICALLY)
            && $this->getOptimizationType() === OptimizationType::IMMEDIATELY;
    }

    public function isOptimizeImagesByCron(): bool
    {
        return $this->isSetFlag(self::OPTIMIZE_AUTOMATICALLY)
            && $this->getOptimizationType() === OptimizationType::CRON;
    }

    public function getOptimizationType(): string
    {
        return (string)$this->getValue(self::OPTIMIZE_TYPE);
    }
}
