<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
 * @package Page Speed Optimizer Premium Functionality for Magento 2 (System)
 */

namespace Amasty\OptimizerPremiumFunctionality\Model\Config;

use Amasty\ImageOptimizer\Model\Queue\ImageQueueService;
use Amasty\OptimizerPremiumFunctionality\Model\OptionSource\OptimizationType as OptimizationOptions;
use Magento\Framework\App\Cache\TypeListInterface;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\Config\Value;
use Magento\Framework\Data\Collection\AbstractDb;
use Magento\Framework\Message\ManagerInterface;
use Magento\Framework\Model\Context;
use Magento\Framework\Model\ResourceModel\AbstractResource;
use Magento\Framework\Registry;

class OptimizationType extends Value
{
    /**
     * @var ManagerInterface
     */
    private $manager;

    /**
     * @var ImageQueueService
     */
    private $imageQueueService;

    public function __construct(
        Context $context,
        Registry $registry,
        ScopeConfigInterface $config,
        TypeListInterface $cacheTypeList,
        ManagerInterface $manager,
        ImageQueueService $imageQueueService,
        AbstractResource $resource = null,
        AbstractDb $resourceCollection = null,
        array $data = []
    ) {
        parent::__construct($context, $registry, $config, $cacheTypeList, $resource, $resourceCollection, $data);
        $this->manager = $manager;
        $this->imageQueueService = $imageQueueService;
    }

    public function afterSave()
    {
        if ($this->isValueChanged()
            && $this->getValue() == OptimizationOptions::IMMEDIATELY
            && $this->imageQueueService->getQueueSize()
        ) {
            $this->manager->addWarningMessage(
                __(
                    "Please mind that by switching from 'By Cron' to " .
                    "'Immediately after Uploading' options a number of images can be still in the queue. " .
                    "The console command 'bin/magento amasty:optimizer:optimize' should be run to optimize " .
                    "the images left in the queue."
                )
            );
        }

        return parent::afterSave();
    }
}
