<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
 * @package Page Speed Optimizer Premium Functionality for Magento 2 (System)
 */

namespace Amasty\OptimizerPremiumFunctionality\Cron;

use Amasty\ImageOptimizer\Api\ImageQueueServiceInterface;
use Amasty\OptimizerPremiumFunctionality\Model\Constants;
use Amasty\OptimizerPremiumFunctionality\Model\ImageOptimizerConfigProvider as ConfigProvider;
use Amasty\ImageOptimizer\Model\ImageProcessor;
use Amasty\ImageOptimizer\Model\Queue\Queue;

class OptimizeQueue
{
    /**
     * @var ImageQueueServiceInterface
     */
    private $queueService;

    /**
     * @var ImageProcessor
     */
    private $imageProcessor;

    /**
     * @var ConfigProvider
     */
    private $configProvider;

    public function __construct(
        ImageQueueServiceInterface $queueService,
        ImageProcessor  $imageProcessor,
        ConfigProvider $configProvider
    ) {
        $this->queueService = $queueService;
        $this->imageProcessor = $imageProcessor;
        $this->configProvider = $configProvider;
    }

    /**
     * @return void
     */
    public function execute(): void
    {
        if (!$this->configProvider->isOptimizeImagesByCron()) {
            return;
        }
        foreach ($this->queueService->shuffleQueues(100, [Constants::CRON_QUEUE]) as $queue) {
            $this->imageProcessor->process($queue);
        }
    }
}
