define([
    'Magento_InventoryInStorePickupFrontend/js/view/store-pickup',
    'Magento_Checkout/js/model/quote',
    'Magento_Checkout/js/checkout-data',
    'Magento_Checkout/js/model/checkout-data-resolver',
    'Amasty_CheckoutInStorePickup/js/model/in-store-pickup',
    'Amasty_CheckoutInStorePickup/js/action/shipping-address-form'
], function (
    Component,
    quote,
    checkoutData,
    checkoutDataResolver,
    inStorePickupModel,
    shippingAddressFormActions
) {
    return Component.extend({
        defaults: {
            imports: {
                nearbySearchRadius: 'checkout.steps.store-pickup:nearbySearchRadius'
            }
        },
        initialize: function () {
            this._super();

            quote.shippingMethod.subscribe(this.shippingMethodObserver);
            inStorePickupModel.isInStorePickup.subscribe(this.isInStorePickupObserver);
            this.shippingMethodObserver(quote.shippingMethod());

            return this;
        },

        initObservable: function () {
            this._super().observe(['isInStorePickup']);

            return this;
        },

        /**
         * @param {Object} shippingMethod
         * @returns {void}
         */
        shippingMethodObserver: function (shippingMethod) {
            let isInStorePickup = shippingMethod
                && shippingMethod['carrier_code'] === 'instore';

            inStorePickupModel.isInStorePickup(Boolean(isInStorePickup));
        },

        /**
         * @param {Boolean} isInStorePickup
         * @returns {void}
         */
        isInStorePickupObserver: function (isInStorePickup) {
            shippingAddressFormActions.toggle(!isInStorePickup);

            if (!isInStorePickup) {
                checkoutData.setSelectedPickupAddress(null);
                checkoutDataResolver.resolveShippingAddress();
                checkoutDataResolver.resolveBillingAddress();
            }
        }
    });
});
