define([
    'jquery',
    'uiRegistry',
    'Magento_Checkout/js/model/quote'
], function ($, registry, quote) {
    'use strict';

    return function (Shipping) {
        return Shipping.extend({
            /**
             * Validate guest email
             */
            validateGuestEmail: function () {
                let loginFormSelector = 'form[data-role=email-with-possible-login]';

                $(loginFormSelector).validation();

                return $(loginFormSelector + ' input[type=email]').valid();
            },

            validateShippingInformation: function () {
                let shippingMethod = quote.shippingMethod();

                if (shippingMethod && shippingMethod['carrier_code'] === 'instore') {
                    this.source.set('params.invalid', false);

                    return !this.source.get('params.invalid');
                }

                return this._super();
            }
        });
    };
});
