/**
 * Billing address view mixin for restrict billing address copy from shipping
 */
define([
    'Amasty_CheckoutInStorePickup/js/model/in-store-pickup'
], function (inStorePickupModel) {
    'use strict';

    return function (billingAddress) {
        var isEditAddressCalled = false;

        return billingAddress.extend({
            initObservable: function () {
                this._super();

                this.isAddressSameAsShipping.subscribe(this.billingSameAsShippingObserver, this);
                inStorePickupModel.isStoreSelected.subscribe(this.inStorePickupStateObserver, this);
                this.currentBillingAddress.subscribe(this.billingAddressSubscriber, this);

                return this;
            },

            /**
             * Restrict copy billing from shipping while pickup is selected
             *
             * @param {Boolean} state
             */
            billingSameAsShippingObserver: function (state) {
                if (state && inStorePickupModel.isInStorePickup()) {
                    this.isAddressSameAsShipping(false);
                }
            },

            /**
             * Mark view model to not be able to copy shipping while pickup is selected.
             * note: this method processing several times if billing address for each payment
             *       do not modify quote billing address from here for avoid high load
             */
            inStorePickupStateObserver: function () {
                if (!inStorePickupModel.isInStorePickup()) {
                    return
                }

                // check this flag to force display billing form during first page load
                if (this.isAddressSameAsShipping()) {
                    this.forceEdit = true;
                }

                this.isAddressSameAsShipping(false);
                if (this.currentBillingAddress() === null || this.forceEdit) {
                    this.forceEdit = false;
                    this.editAddress();
                }
            },

            /**
             * Avoid hidden empty billing address with disabled place button
             *
             * @param {Object} address
             */
            billingAddressSubscriber: function (address) {
                if (address === null && inStorePickupModel.isInStorePickup() && !isEditAddressCalled) {
                    this.editAddress();
                }
            },

            /**
             * Edit address action. Setting a flag before calling the parent method,
             * and resetting the flag after exiting it.
             */
            editAddress: function () {
                isEditAddressCalled = true;
                this._super();
                this.isAddressDetailsVisible(false);
                isEditAddressCalled = false;
            }
        });
    };
});
