<?php

namespace Amasty\MultiInventory\Ui\DataProvider;

use Amasty\MultiInventory\Model\ResourceModel\Warehouse\Import\Collection;
use Amasty\MultiInventory\Model\ResourceModel\Warehouse\Import\CollectionFactory;
use Magento\Framework\App\RequestInterface;
use Magento\Ui\DataProvider\AbstractDataProvider;

/**
 * Class ImportDataProvider
 */
class ImportDataProvider extends AbstractDataProvider
{
    /**
     * @var Collection
     */
    protected $collection;

    /**
     * @var RequestInterface
     */
    private $request;

    /**
     * ImportDataProvider constructor.
     *
     * @param string $name
     * @param string $primaryFieldName
     * @param string $requestFieldName
     * @param RequestInterface $request
     * @param CollectionFactory $collectionFactory
     * @param array $meta
     * @param array $data
     */
    public function __construct(
        $name,
        $primaryFieldName,
        $requestFieldName,
        RequestInterface $request,
        CollectionFactory $collectionFactory,
        array $meta = [],
        array $data = []
    ) {
        parent::__construct($name, $primaryFieldName, $requestFieldName, $meta, $data);
        $this->collection = $collectionFactory->create();
        $this->request = $request;
    }

    /**
     * Get data
     *
     * @return array
     */
    public function getData()
    {
        $number = $this->request->getParam('import_number');

        $config = $this->getConfigData();

        if (!$this->getCollection()->isLoaded()) {
            if ($number) {
                $config['params']['import_number'] = $number;
                $this->setConfigData($config);
                $this->getCollection()->addFieldToFilter('import_number', $number);
            }
            $this->getCollection()->joinProducts();
            $this->getCollection()->load();
        }
        $items = $this->getCollection()->toArray();

        return $items;
    }
}
