<?php

namespace Amasty\MultiInventory\Observer\Sales\Order;

use Amasty\MultiInventory\Helper\System as HelperSystem;

/**
 * Class CreateInvoiceObserver
 */
class CreateInvoiceObserver extends CreateAbstractObserver
{
    /**
     * @return bool
     */
    protected function isCanExecute()
    {
        return parent::isCanExecute() && $this->system->getPhysicalDecreese() == HelperSystem::ORDER_INVOICED;
    }

    /**
     * @return string
     */
    protected function getEventName()
    {
        return 'invoice';
    }
}
