<?php

namespace Amasty\MultiInventory\Model\Export;

use Amasty\MultiInventory\Api\Data\WarehouseInterface;
use Amasty\MultiInventory\Model\ResourceModel\Warehouse\CollectionFactory;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\ImportExport\Model\Export\Factory as ExportFactory;
use Magento\ImportExport\Model\ResourceModel\CollectionByPagesIteratorFactory;
use Magento\Store\Model\StoreManagerInterface;

class SourceExport extends AbstractExport
{
    const MW_SOURCE_EXPORT_ENTITY = 'amasty_warehouse_source_export';

    const COLUMNS = [
        'source_code',
        'name',
        'enabled',
        'description',
        'latitude',
        'longitude',
        'country_id',
        'region_id',
        'region',
        'city',
        'street',
        'postcode',
        'contact_name',
        'email',
        'phone',
        'fax',
        'order_email_notification',
        'low_stock_notification',
        'dhl',
        'fedex',
        'flatrate',
        'tablerate',
        'freeshipping',
        'ups',
        'usps'
    ];

    public function __construct(
        ScopeConfigInterface $scopeConfig,
        StoreManagerInterface $storeManager,
        ExportFactory $collectionFactory,
        CollectionByPagesIteratorFactory $resourceColFactory,
        CollectionFactory $collection,
        array $data = []
    ) {
        parent::__construct($scopeConfig, $storeManager, $collectionFactory, $resourceColFactory, $data);
        $this->collectionFactory = $collection;
    }

    public function exportItem($item)
    {
        $row = $item->toArray();

        if ((string)(int)$row['region_id'] !== $row['region_id']) {
            $row['region'] = $row['region_id'];
            $row['region_id'] = '';
        }

        if (empty($row[WarehouseInterface::IS_SHIPPING])) {
            foreach (['dhl', 'fedex', 'flatrate', 'tablerate', 'freeshipping', 'ups', 'usps'] as $carrier) {
                $row[$carrier] = '';
            }
        }

        $row['name'] = trim($row['name']);
        $row['source_code'] = preg_replace('/\s/is', '_', trim($row['source_code']));

        $this->getWriter()->writeRow($row);
    }

    public function addAttributesToCollection()
    {
        $this->collection->getSelect()->reset(\Zend_Db_Select::COLUMNS);
        $this->collection->addFieldToFilter(WarehouseInterface::IS_GENERAL, 0)
            ->addFieldToSelect(WarehouseInterface::CODE, 'source_code')
            ->addFieldToSelect(WarehouseInterface::TITLE, 'name')
            ->addFieldToSelect(WarehouseInterface::MANAGE, 'enabled')
            ->addFieldToSelect(WarehouseInterface::DESCRIPTION, 'description')
            ->addFieldToSelect(WarehouseInterface::LAT, 'latitude')
            ->addFieldToSelect(WarehouseInterface::LNG, 'longitude')
            ->addFieldToSelect(WarehouseInterface::COUNTRY, 'country_id')
            ->addFieldToSelect(WarehouseInterface::STATE, 'region_id')
            ->addFieldToSelect(WarehouseInterface::CITY, 'city')
            ->addFieldToSelect(WarehouseInterface::ADDRESS, 'street')
            ->addFieldToSelect(WarehouseInterface::ZIP, 'postcode')
            ->addFieldToSelect(WarehouseInterface::EMAIL, 'email')
            ->addFieldToSelect(WarehouseInterface::PHONE, 'phone')
            ->addFieldToSelect(WarehouseInterface::EMAIL, 'email')
            ->addFieldToSelect(WarehouseInterface::ORDER_EMAIL_NOTIFICATION)
            ->addFieldToSelect(WarehouseInterface::LOW_STOCK_NOTIFICATION)
            ->addFieldToSelect(WarehouseInterface::IS_SHIPPING);

        foreach (['dhl', 'fedex', 'flatrate', 'tablerate', 'freeshipping', 'ups', 'usps'] as $index => $carrier) {
            $alias = 'wh_shipping' . $index;
            $this->collection->getSelect()->joinLeft(
                [$alias => $this->collection->getTable('amasty_multiinventory_warehouse_shipping')],
                $alias . '.warehouse_id = main_table.warehouse_id'
                    . ' and ' . $alias . '.shipping_method=\''. $carrier .'\'',
                [$alias . '.rate as ' . $carrier]
            );
        }
    }

    /**
     * @return string
     */
    public function getEntityTypeCode()
    {
        return self::MW_SOURCE_EXPORT_ENTITY;
    }
}
