<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Most Viewed or Automatic Related Products Hyva Compatibility by Amasty
 */

declare(strict_types=1);

namespace Amasty\MostviewedHyva\ViewModel;

use Amasty\Mostviewed\Helper\Config;
use Magento\Framework\View\Element\Block\ArgumentInterface;

class TopmenuLink implements ArgumentInterface
{
    /**
     * @var \Magento\Framework\UrlInterface
     */
    private $url;

    /**
     * @var Config
     */
    protected $config;

    /**
     * @var \Magento\Cms\Model\PageFactory
     */
    private $pageFactory;

    /**
     * @param \Magento\Framework\UrlInterface $url
     * @param Config $config
     * @param \Magento\Cms\Model\PageFactory $pageFactory
     */
    public function __construct(
        \Magento\Framework\UrlInterface $url,
        Config $config,
        \Magento\Cms\Model\PageFactory $pageFactory
    ) {
        $this->url = $url;
        $this->config = $config;
        $this->pageFactory = $pageFactory;
    }

    /**
     * Return Link Label
     *
     * @return string
     */
    public function getLabel()
    {
        return (string)$this->config->getModuleConfig('bundle_packs/menu_item_label');
    }

    /**
     * Check is first in menu
     *
     * @return bool
     */
    public function isDisplayFirst()
    {
        return $this->getPosition() == $this->getTopMenuEnabled();
    }

    /**
     * Return is menu enabled
     *
     * @return int
     */
    public function getTopMenuEnabled()
    {
        return (int) $this->config->getModuleConfig('bundle_packs/top_menu_enabled');
    }

    /**
     * Retrieves initial menu position
     *
     * @return int
     */
    private function getPosition()
    {
        return \Amasty\Mostviewed\Model\OptionSource\TopMenuLink::DISPLAY_FIRST;
    }

    /**
     * Returns all budles url
     *
     * @return string
     */
    public function getBundlesUrl()
    {
        $pageIdentifier = $this->config->getModuleConfig('bundle_packs/cms_page');

        $identifierWithId = explode('|', $pageIdentifier);

        $page = $this->pageFactory->create()->load($identifierWithId[0], 'identifier');
        $url = '';

        if ($page && $page->isActive()) {
            $url = $this->url->getUrl($identifierWithId[0]);
        }

        return $url;
    }
}
