<?php
declare(strict_types=1);
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Most Viewed or Automatic Related Products Hyva Compatibility by Amasty
 */

namespace Amasty\MostviewedHyva\ViewModel;

use Magento\Framework\View\Element\Block\ArgumentInterface;
use Hyva\Theme\Model\ViewModelRegistry;
use Hyva\GraphqlViewModel\ViewModel\GraphqlViewModel;

/**
 * GraphQl queries for bundle pack
 */
class BundlePackQuery implements ArgumentInterface
{
    /**
     * @var ViewModelRegistry
     */
    private $viewModels;

    /**
     * @var GraphqlViewModel
     */
    private $viewModelGraphQl;

    /**
     * Constructor
     *
     * @param ViewModelRegistry $viewModels
     */
    public function __construct(
        ViewModelRegistry $viewModels
    ) {
        $this->viewModels = $viewModels;
    }

    /**
     * Returns GraphQl query for products in bundle pack
     *
     * @return string
     */
    public function queryProducts(): string
    {
        $viewModelGraphQl = $this->viewModels->require(GraphqlViewModel::class);

        $query = $viewModelGraphQl->query(
            "ambundle_pack_query",
            'query ($uid: String!) {amMostviewedBundlePacks(uid: $uid){
    main_product {
      add_to_cart_url
      image {
        label
        url
      }
      name
      price_range {
        minimum_price {
          regular_price {
            value
            currency
          }
          final_price {
            value
            currency
          }
        }
        maximum_price {
          regular_price {
            value
            currency
          }
          final_price {
            value
            currency
          }
        }
      }
      product_url
      rating_summary
      thumbnail {
        label
        url
      }
      uid
      url_key
    }
    bundleItems: items {
      pack_id
      apply_condition
      apply_for_parent
      block_title
      discount_amount
      discount_type
      conditional_discounts {
        number_items
        discount_amount
      }
      bundleProducts: items {
        discount_amount
        qty
        product {
          __typename
          add_to_cart_url
          image {
            label
            url
          }
          name
          price_range {
            minimum_price {
              regular_price {
                value
                currency
              }
              final_price {
                value
                currency
              }
            }
            maximum_price {
              regular_price {
                value
                currency
              }
              final_price {
                value
                currency
              }
            }
          }
          product_url
          rating_summary
          stock_status
           small_image {
            label
            url
          }
          thumbnail {
            label
            url
          }
          uid
          url_key
          visibility
        }
      }
    }
}}'
        );

        return  $query;
    }
}
