<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Most Viewed or Automatic Related Products Hyva Compatibility by Amasty
 */

declare(strict_types=1);

namespace Amasty\MostviewedHyva\ViewModel;

use Magento\Framework\View\Element\Block\ArgumentInterface;
use Magento\Framework\Module\Manager;

class BundlePack implements ArgumentInterface
{

    /**
     * @var Manager
     */
    private $moduleManager;

    /**
     * @param Manager $moduleManager
     */
    public function __construct(
        Manager $moduleManager,
    ) {
        $this->moduleManager = $moduleManager;
    }

    /**
     * Get is Amasty_OutofstockHyvaCompatibility module enabled
     *
     * @return bool
     */
    public function isOutofstockHyvaCompatibility()
    {
        return $this->moduleManager->isEnabled('Amasty_OutofstockHyvaCompatibility');
    }

    /**
     * Returns ids of allowed bundle packs
     *
     * @param array $bundles
     * @return array
     */
    public function getAllowedPackIds(array $bundles = []): array
    {
        $packIds = [];
        foreach ($bundles as $pack) {
            if ($pack->getProductIds()) {
                $packIds[] = (int)$pack->getPackId();
            }
        }

        return $packIds;
    }
}
