<?php

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Most Viewed or Automatic Related Products Hyva Compatibility by Amasty
 */

declare(strict_types=1);

namespace Amasty\MostviewedHyva\Plugin\Hyva\Theme\ViewModel;

use Hyva\Theme\ViewModel\ProductList as Subject;
use Amasty\Mostviewed\Model\ProductProvider;
use Amasty\Mostviewed\Model\OptionSource\BlockPosition;
use Magento\Framework\View\LayoutInterface;
use Hyva\Theme\Service\CurrentTheme;
use Magento\Quote\Model\Quote\Item;

class ProductList
{
    /**
     * @var array
     */
    private const TYPE_MAP = [
        'related' => BlockPosition::PRODUCT_INTO_RELATED,
        'upsell' => BlockPosition::PRODUCT_INTO_UPSELL
    ];

    /**
     * @var ProductProvider
     */
    private $productProvider;

    /**
     * @var LayoutInterface
     */
    private $layout;

    /**
     * @var CurrentTheme
     */
    private $currentTheme;

    /**
     * @param ProductProvider $productProvider
     * @param LayoutInterface $layout
     * @param CurrentTheme $currentTheme
     */
    public function __construct(ProductProvider $productProvider, LayoutInterface $layout, CurrentTheme $currentTheme)
    {
        $this->productProvider = $productProvider;
        $this->layout = $layout;
        $this->currentTheme = $currentTheme;
    }

    /**
     * Apply add_into logic
     *
     * @param Subject $subject
     * @param array $result
     * @param string $linkType
     * @param mixed $product
     *
     * @return array
     */
    public function afterGetLinkedItems(Subject $subject, array $result, string $linkType, $product): array
    {
        if (!$this->currentTheme->isHyva()) {
            return $result;
        }
        $type = self::TYPE_MAP[$linkType] ?? null;
        if ($type) {
            $block = $this->layout->getBlock($linkType);
            $newCollection = $this->productProvider->modifyCollection(
                $type,
                $product,
                $result,
                [],
                $block
            );

            if (!empty($newCollection)) {
                return is_array($newCollection) ? $newCollection : $newCollection->getAllIds();
            }
        }

        return $result;
    }

    /**
     * Modify crosssell collection
     *
     * @param Subject $subject
     * @param array $result
     * @param Item|null $cartItem
     *
     * @return array
     */
    public function afterGetCrosssellItems(Subject $subject, array $result, $cartItem = null): array
    {
        if (!$this->currentTheme->isHyva() || !$cartItem) {
            return $result;
        }
        $block = $this->layout->getBlock('crosssell');
        $newCollection = $this->productProvider->modifyCollection(
            BlockPosition::CART_INTO_CROSSSEL,
            $cartItem->getProduct(),
            $result,
            array_map(function ($item) {
                return $item->getProductId();
            }, $cartItem->getQuote()->getAllVisibleItems()),
            $block
        );

        if (!empty($newCollection)) {
            return is_array($newCollection) ? $newCollection : $newCollection->getAllIds();
        }

        return $result;
    }
}
