<?php

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Most Viewed or Automatic Related Products Hyva Compatibility by Amasty
 */

declare(strict_types=1);

namespace Amasty\MostviewedHyva\Plugin\Catalog\Block\Product\View;

use Magento\Catalog\Block\Product\View\Details as Subject;
use Hyva\Theme\Service\CurrentTheme;
use Magento\Framework\View\LayoutInterface;
use Magento\Framework\Exception\LocalizedException;

class Details
{
    /**
     * @var CurrentTheme
     */
    private $currentTheme;

    /**
     * @var array
     */
    private $blockNames;

    /**
     * @var string
     */
    private $blockPrefix;

    /**
     * @param CurrentTheme $currentTheme
     * @param array $blockNames
     * @param string $blockPrefix
     */
    public function __construct(CurrentTheme $currentTheme, array $blockNames = [], string $blockPrefix = 'amrelated_')
    {
        $this->currentTheme = $currentTheme;
        $this->blockNames = $blockNames;
        $this->blockPrefix = $blockPrefix;
    }

    /**
     * Render block
     *
     * @param Subject $subject
     * @param string $result
     *
     * @return string
     * @throws LocalizedException
     */
    public function afterToHtml(Subject $subject, string $result): string
    {
        $currentName = $subject->getNameInLayout();
        if ($this->currentTheme->isHyva() && in_array($currentName, array_keys($this->blockNames))) {
            $layout = $subject->getLayout();
            $beforeBlockName = $this->getBeforeBlockName($currentName);
            if ($beforeBlockName) {
                $result = $this->renderBlockByName($beforeBlockName, $layout) . $result;
            }
        }

        return $result;
    }

    /**
     * Retrieve before block name
     *
     * @param string $blockName
     *
     * @return string|null
     */
    private function getBeforeBlockName(string $blockName): ?string
    {
        return $this->blockPrefix . $this->blockNames[$blockName]['beforeName'] ?? null;
    }

    /**
     * Render block by its name
     *
     * @param string $blockName
     * @param LayoutInterface $layout
     *
     * @return string
     */
    private function renderBlockByName(string $blockName, LayoutInterface $layout): string
    {
        $block = $layout->getBlock($blockName);

        if ($block) {
            $result = $block->toHtml();
            $layout->unsetElement($blockName);

            return $result;
        }

        return '';
    }
}
