<?php

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Most Viewed or Automatic Related Products Hyva Compatibility by Amasty
 */

declare(strict_types=1);

namespace Amasty\MostviewedHyva\Model\ResourceModel\Layout;

use Magento\Widget\Model\ResourceModel\Layout\Update as BaseUpdate;
use Magento\Framework\View\Design\ThemeInterface;
use Magento\Framework\App\ScopeInterface;
use Magento\Framework\Model\ResourceModel\Db\Context;
use Magento\Framework\Cache\FrontendInterface;
use Hyva\Theme\Service\CurrentTheme;
use Magento\Framework\Exception\LocalizedException;

class Update extends BaseUpdate
{
    /**
     * @var CurrentTheme
     */
    private $currentTheme;

    /**
     * @var array
     */
    private $handles = [];

    /**
     * @var array
     */
    private $layoutUpdateCache;

    /**
     * @param Context $context
     * @param FrontendInterface $cache
     * @param CurrentTheme $currentTheme
     * @param array $handles
     * @param string $connectionName
     */
    public function __construct(
        Context $context,
        FrontendInterface $cache,
        CurrentTheme $currentTheme,
        array $handles = [],
        $connectionName = null
    ) {
        parent::__construct($context, $cache, $connectionName);
        $this->currentTheme = $currentTheme;
        $this->handles = $handles;
    }

    /**
     * Retrieve layout updates by handle
     *
     * @param string $handle
     * @param ThemeInterface $theme
     * @param ScopeInterface $store
     *
     * @return string
     * @throws LocalizedException
     */
    public function fetchUpdatesByHandle($handle, ThemeInterface $theme, ScopeInterface $store): string
    {
        $bind = ['theme_id' => $theme->getId(), 'store_id' => $store->getId()];

        $cacheKey = implode('-', $bind);
        if (!isset($this->layoutUpdateCache[$cacheKey])) {
            $this->layoutUpdateCache[$cacheKey] = [];
            foreach ($this->getConnection()->fetchAll($this->_getFetchUpdatesByHandleSelect(), $bind) as $layout) {
                if (!isset($this->layoutUpdateCache[$cacheKey][$layout['handle']])) {
                    $this->layoutUpdateCache[$cacheKey][$layout['handle']] = '';
                }
                $this->layoutUpdateCache[$cacheKey][$layout['handle']] .= $this->modifyLayoutByHandle(
                    $layout['xml'],
                    $layout['handle']
                );
            }
        }

        return $this->layoutUpdateCache[$cacheKey][$handle] ?? '';
    }

    /**
     * Modify handle xml
     *
     * @param string $xml
     * @param string $handleName
     *
     * @return string
     */
    private function modifyLayoutByHandle(string $xml, string $handleName): string
    {
        if ($this->currentTheme->isHyva() && in_array($handleName, array_keys($this->handles))) {
            $rules = $this->handles[$handleName];
            foreach ($rules as $searchPath => $replacePath) {
                if ($searchPath === 'remove' && is_array($replacePath)) {
                    $xml = $this->removePath($replacePath, $xml);
                } else {
                    $xml = str_replace($searchPath, $replacePath, $xml);
                }
            }
        }

        return $xml;
    }

    /**
     * Remove some path of xml
     *
     * @param array $replacePath
     * @param string $result
     *
     * @return string
     */
    private function removePath(array $replacePath, string $result): string
    {
        foreach ($replacePath as $blockNameCondition => $path) {
            if (mb_stripos($result, $blockNameCondition) !== false) {
                foreach ($path as $removeString) {
                    $result = str_replace($removeString, '', $result);
                }
            }
        }

        return $result;
    }
}
