<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Most Viewed or Automatic Related Products Hyva Compatibility by Amasty
 */

namespace Amasty\MostviewedHyva\Model\Resolver;

use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;
use Magento\GraphQl\Model\Query\ContextInterface;

class ConditionalDiscounts implements ResolverInterface
{
    /**
     * Resolver to retrieve conditional discounts for a pack
     *
     * @param Field $field
     * @param ContextInterface $context
     * @param ResolveInfo $info
     * @param array|null $value
     * @param array|null $args
     * @return string
     * @throws LocalizedException
     *
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function resolve(Field $field, $context, ResolveInfo $info, array $value = null, array $args = null): array
    {
        $pack = $value['model'];
        $conditionalDiscounts = $pack->getExtensionAttributes()->getConditionalDiscounts();
        $result = [];

        if (is_array($conditionalDiscounts)) {
            foreach ($conditionalDiscounts as $conditionalDiscount) {
                /** @var \Amasty\Mostviewed\Api\Data\ConditionalDiscountInterface $conditionalDiscount */
                $result[] = [
                    "number_items" => $conditionalDiscount->getNumberItems(),
                    "discount_amount" =>  $conditionalDiscount->getDiscountAmount()
                ];
            }
        }

        return $result;
    }
}
