<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Most Viewed or Automatic Related Products Hyva Compatibility by Amasty
 */

namespace Amasty\MostviewedHyva\Controller\Result;

use Magento\Framework\Translate\InlineInterface;
use Magento\Framework\Serialize\Serializer\Json as JsonSerializer;

class Json extends \Magento\Framework\Controller\Result\Json
{
    /**
     * @var JsonSerializer
     */
    private JsonSerializer $jsonSerializer;

    /**
     * @param InlineInterface $translateInline
     * @param JsonSerializer $jsonSerializer
     */
    public function __construct(
        InlineInterface $translateInline,
        JsonSerializer $jsonSerializer
    ) {
        parent::__construct($translateInline, $jsonSerializer);
        $this->jsonSerializer = $jsonSerializer;
    }

    /**
     * GetData method
     *
     * @return array
     */
    public function getData(): array
    {
        $jsonData = [];

        if ($this->json) {
            try {
                $jsonData = $this->jsonSerializer->unserialize($this->json);
            } catch (\Exception) {
                return [];
            }
        }

        return is_array($jsonData) ? $jsonData : [];
    }
}
