<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Most Viewed or Automatic Related Products Hyva Compatibility by Amasty
 */
// phpcs:disable Generic.Files.LineLength.TooLong
namespace Amasty\MostviewedHyva\Controller\Cart;

use Amasty\Mostviewed\Model\Block\Renderer\Flag as RendererFlag;
use Amasty\Mostviewed\Model\Cart\Add\IsProductHasRequiredOptions;
use Amasty\Mostviewed\Model\Cart\Add\MessageManager as CustomMessageManager;
use Amasty\Mostviewed\Model\Cart\AddProductsByIds;
use Amasty\Mostviewed\Model\ConfigProvider;
use Magento\Catalog\Api\Data\ProductInterface;
use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\Catalog\Helper\Product;
use Magento\Checkout\Helper\Cart;
use Magento\Checkout\Model\Cart as CustomerCart;
use Magento\Framework\Controller\Result\Json as JsonResult;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\Filter\LocalizedToNormalized;
use Magento\Framework\Url\Helper\Data as UrlHelper;
use Magento\Framework\View\LayoutInterface;
use Amasty\Mostviewed\Model\Block\Renderer\Flag;
use Magento\Framework\View\Result\PageFactory;
use Hyva\Theme\Service\CurrentTheme;

class Add extends \Amasty\Mostviewed\Controller\Cart\Add
{
    private const BUNDLE_PRODUCT_TYPE = 'bundle';

    /**
     * @var UrlHelper
     */
    private $urlHelper;

    /**
     * @var Flag
     */
    private $rendererFlag;

    /**
     * @var CurrentTheme
     */
    private $currentTheme;

    /**
     * Constructor
     *
     * @param \Magento\Framework\App\Action\Context $context
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     * @param \Magento\Checkout\Model\Session $checkoutSession
     * @param \Magento\Store\Model\StoreManagerInterface $storeManager
     * @param \Magento\Framework\Data\Form\FormKey\Validator $formKeyValidator
     * @param CustomerCart $cart
     * @param ProductRepositoryInterface $productRepository
     * @param Product $productHelper
     * @param PageFactory $resultPageFactory
     * @param UrlHelper $urlHelper
     * @param \Magento\Framework\Registry $coreRegistry
     * @param \Magento\Framework\View\LayoutFactory $layoutFactory
     * @param AddProductsByIds $addProductsByIds
     * @param \Amasty\Mostviewed\Model\Di\Wrapper $generateAmastyCartResponse
     * @param \Amasty\Mostviewed\Model\Pack\Cart\ProductRegistry $productRegistry
     * @param \Amasty\Mostviewed\Model\Pack\Cart\GenerateConfirmMessage $generateConfirmMessage
     * @param \Magento\Framework\DataObject\Factory $dataObjectFactory
     * @param ConfigProvider $configProvider
     * @param Flag $rendererFlag
     * @param CustomMessageManager $customMessageManager
     * @param IsProductHasRequiredOptions $isProductHasRequiredOptions
     * @param Cart $cartHelper
     * @param ResultFactory $resultFactory
     * @param CurrentTheme $currentTheme
     * @param LocalizedToNormalized|null $localizedToNormalized
     */
    public function __construct(
        \Magento\Framework\App\Action\Context                     $context,
        \Magento\Framework\App\Config\ScopeConfigInterface        $scopeConfig,
        \Magento\Checkout\Model\Session                           $checkoutSession,
        \Magento\Store\Model\StoreManagerInterface                $storeManager,
        \Magento\Framework\Data\Form\FormKey\Validator            $formKeyValidator,
        CustomerCart                                              $cart,
        ProductRepositoryInterface                                $productRepository,
        Product                                                   $productHelper,
        PageFactory                                               $resultPageFactory,
        UrlHelper                                                 $urlHelper,
        \Magento\Framework\Registry                               $coreRegistry,
        \Magento\Framework\View\LayoutFactory                     $layoutFactory,
        \Amasty\Mostviewed\Model\Cart\AddProductsByIds            $addProductsByIds,
        \Amasty\Mostviewed\Model\Di\Wrapper                       $generateAmastyCartResponse,
        \Amasty\Mostviewed\Model\Pack\Cart\ProductRegistry        $productRegistry,
        \Amasty\Mostviewed\Model\Pack\Cart\GenerateConfirmMessage $generateConfirmMessage,
        \Magento\Framework\DataObject\Factory                     $dataObjectFactory,
        ConfigProvider                                            $configProvider,
        RendererFlag                                              $rendererFlag,
        CustomMessageManager                                      $customMessageManager,
        IsProductHasRequiredOptions                               $isProductHasRequiredOptions,
        Cart                                                      $cartHelper,
        ResultFactory                                             $resultFactory,
        CurrentTheme                                              $currentTheme,
        LocalizedToNormalized                                     $localizedToNormalized = null
    ) {
        parent::__construct(
            $context,
            $scopeConfig,
            $checkoutSession,
            $storeManager,
            $formKeyValidator,
            $cart,
            $productRepository,
            $productHelper,
            $resultPageFactory,
            $urlHelper,
            $coreRegistry,
            $layoutFactory,
            $addProductsByIds,
            $generateAmastyCartResponse,
            $productRegistry,
            $generateConfirmMessage,
            $dataObjectFactory,
            $configProvider,
            $rendererFlag,
            $customMessageManager,
            $isProductHasRequiredOptions,
            $cartHelper
        );

        $this->currentTheme = $currentTheme;
        $this->urlHelper = $urlHelper;
        $this->rendererFlag = $rendererFlag;
        $this->resultFactory = $resultFactory;
    }

    /**
     * Execute method
     *
     * @return JsonResult
     */
    public function execute(): JsonResult
    {
        /** @var \Amasty\MostviewedHyva\Controller\Result\Json $jsonResult */
        $jsonResult = parent::execute();

        $jsonResultData = $jsonResult->getData();
        if (!empty($jsonResultData['message'])) {
            return $this->generateAjaxResponse('addPackSuccessMessage', true);
        }

        return $jsonResult;
    }

    /**
     * Generate html for product options
     *
     * @param ProductInterface $product
     * @param LayoutInterface $layout
     *
     * @return mixed|string
     */
    protected function generateOptionsHtml(ProductInterface $product, LayoutInterface $layout)
    {
        if ($this->currentTheme->isHyva()) {
            if ($product->getTypeId() === self::BUNDLE_PRODUCT_TYPE) {
                $block = $layout->getBlock('product.info.bundle.options');
            } else {
                $block = $layout->getBlock('product.info');

                if (!$block) {
                    $block = $layout->createBlock(
                        \Magento\Catalog\Block\Product\View::class,
                        'product.info',
                        ['data' => []]
                    );
                }
            }
        } else {
            $block = $layout->getBlock('product.info');

            if (!$block) {
                $block = $layout->createBlock(
                    \Magento\Catalog\Block\Product\View::class,
                    'product.info',
                    ['data' => []]
                );
            }
        }

        $qty = $this->getRequest()->getParam('amrelated_products')[$product->getId()] ?? 1;
        if ($qty > 1) {
            $values = $product->getPreconfiguredValues();
            $values->setQty($qty);
            $product->setPreconfiguredValues($values);
        }

        $block->setProduct($product);
        $this->rendererFlag->enable();
        $html = $block->toHtml();
        $this->rendererFlag->disable();

        $html = str_replace(
            '"spConfig',
            '"priceHolderSelector": ".price-box[data-product-id=' . $product->getId() . ']", "spConfig',
            $html
        );
        $html = $this->replaceHtmlElements($html, $product);

        return $html;
    }

    /**
     * Replace html elements
     *
     * @param String $html
     * @param ProductInterface $product
     * @return array|mixed|string|string[]
     */
    private function replaceHtmlElements($html, ProductInterface $product)
    {
        /* replace uenc for correct redirect*/
        $currentUenc = $this->urlHelper->getEncodedUrl();
        $refererUrl = $product->getProductUrl();
        $newUenc = $this->urlHelper->getEncodedUrl($refererUrl);

        $container = '#amrelated-product-container-' . $product->getId();
        $priceHolderSelector = sprintf('%s [data-role=priceBox]', $container);

        $html = str_replace($currentUenc, $newUenc, $html);
        $html = str_replace('"swatch-opt"', '"swatch-opt swatch-opt-' . $product->getId() . '"', $html);
        $html = str_replace(
            'spConfig": {"attributes',
            'spConfig": {"containerId":"' . $container . '", "attributes',
            $html
        );
        $html = str_replace(
            '[data-role=swatch-options]',
            '' . $container . ' [data-role=swatch-options]',
            $html
        );
        $html = str_replace(
            '"jsonConfig":',
            '"selectorProduct":".amrelated-product-info","jsonConfig":',
            $html
        );

        if ($this->currentTheme->isHyva()) {
            $html = str_replace(
                'form="product_addtocart_form"',
                '',
                $html
            );
        }

        // replace priceHolderSelector for custom options . needed for find correctly price box
        $html = preg_replace(
            '@"priceHolderSelector":\s*"[^"]*"@s',
            sprintf('"priceHolderSelector":"%s"', $priceHolderSelector),
            $html
        );

        $htmlIdsToReplace = [
            'id="product_addtocart_form',
            'id="product-addtocart-button',
            'id="qty',
            'for="qty',
            'id="related-products-field',
            'id="giftcard-amount-input',
            'id="giftcard-message',
            'id="giftcard_recipient_name',
            'id="giftcard_sender_name',
            '#product_addtocart_form'
        ];

        foreach ($htmlIdsToReplace as $elementId) {
            $html = str_replace(
                $elementId,
                $elementId . '_' . $product->getId(),
                $html
            );
        }

        return $html;
    }
}
