<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Amasty_MetaTagsToElasticSearch
*/


declare(strict_types=1);

namespace Amasty\MetaTagsToElasticSearch\Plugin\Xsearch\Block\Search\Product;

use Amasty\Meta\Helper\Data as MetaHelper;
use Amasty\Meta\Model\Meta\ReplacedData;
use Amasty\MetaTagsToElasticSearch\Model\ConfigProvider;
use Amasty\Xsearch\Block\Search\Product as BlockProduct;
use Magento\Catalog\Model\Product as ProductModel;

class ReplaceShortDescription
{
    /**
     * @var MetaHelper
     */
    private $metaHelper;

    /**
     * @var ConfigProvider
     */
    private $configProvider;

    public function __construct(
        MetaHelper $metaHelper,
        ConfigProvider $configProvider
    ) {
        $this->metaHelper = $metaHelper;
        $this->configProvider = $configProvider;
    }

    /**
     * @see SearchProduct::getDescription()
     *
     * @param BlockProduct $subject
     * @param ProductModel $product
     * @return array
     */
    public function beforeGetDescription(
        BlockProduct $subject,
        ProductModel $product
    ): array {
        if ($this->configProvider->isIntegrationEnabled($product->getStoreId())) {
            $metaData = $this->metaHelper->observeProductPage($product);

            if (isset($metaData[ReplacedData::SHORT_DESCRIPTION])) {
                $product->setShortDescription($metaData[ReplacedData::SHORT_DESCRIPTION]);
            }
        }

        return [$product];
    }
}
