<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Amasty_MetaTagsToElasticSearch
*/


declare(strict_types=1);

namespace Amasty\MetaTagsToElasticSearch\Plugin\ElasticSearch\Model\Indexer\Data\Product\ProductDataMapper;

use Amasty\ElasticSearch\Model\Indexer\Data\Product\ProductDataMapper;
use Amasty\MetaTagsToElasticSearch\Model\Indexer\Data;

class MapMetaAttributesData
{

    /**
     * @var Data
     */
    private $dataMapper;

    public function __construct(Data $dataMapper)
    {
        $this->dataMapper = $dataMapper;
    }

    /**
     * Prepare index data for using in search engine metadata.
     *
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     * @param ProductDataMapper $subject
     * @param array $result
     * @param array $documetData
     * @param $storeId
     * @return array
     */
    public function afterMap(
        ProductDataMapper $subject,
        array $result,
        array $documetData,
        $storeId
    ): array {
        $result = $this->dataMapper->map($result, (int) $storeId);

        return $result;
    }
}
