<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Amasty_MetaTagsToElasticSearch
*/


declare(strict_types=1);

namespace Amasty\MetaTagsToElasticSearch\Model\Indexer;

use Amasty\MetaTagsToElasticSearch\Model\ConfigProvider;
use Magento\Catalog\Api\Data\ProductAttributeInterface;
use Magento\Eav\Model\Config;
use Magento\Eav\Model\Entity\Attribute\AbstractAttribute;

class Validator
{
    /**
     * @var AttributeCodesProvider
     */
    private $codesProvider;

    /**
     * @var ConfigProvider
     */
    private $configProvider;

    /**
     * @var Config
     */
    private $eavConfig;

    public function __construct(
        AttributeCodesProvider $codesProvider,
        ConfigProvider $configProvider
    ) {
        $this->codesProvider = $codesProvider;
        $this->configProvider = $configProvider;
    }

    /**
     * Method validates an ability to execute mapping
     *
     * @param array $documentData
     * @param int $storeId
     * @return bool
     */
    public function validate(int $storeId): bool
    {
        if (!$this->configProvider->isIntegrationEnabled($storeId)
            || empty($this->codesProvider->getAttributeCodes())
        ) {
            return false;
        }

        return true;
    }
}
