<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Amasty_MetaTagsToElasticSearch
*/


declare(strict_types=1);

namespace Amasty\MetaTagsToElasticSearch\Model\Indexer;

class Data
{
    /**
     * @var Validator
     */
    private $validator;

    /**
     * @var ReplaceDataProvider
     */
    private $replaceDataProvider;

    public function __construct(
        Validator $validator,
        ReplaceDataProvider $replaceDataProvider
    ) {
        $this->validator = $validator;
        $this->replaceDataProvider = $replaceDataProvider;
    }

    /**
     * Method adds additional data mapping for search fields
     *
     * @param array $documentData
     * @param int $storeId
     * @return array
     */
    public function map(array $documentData, int $storeId): array
    {
        if (!$this->validator->validate($storeId)) {
            return $documentData;
        }

        $productsDataForMap = $this->replaceDataProvider->getDataForReplace($documentData, $storeId);

        foreach ($documentData as $productId => &$document) {
            if ($productsDataForMap[$productId]) {
                $document = array_replace($document, $productsDataForMap[$productId]);
            }
        }

        return $documentData;
    }
}
