<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Amasty_MetaTagsToElasticSearch
*/


declare(strict_types=1);

namespace Amasty\MetaTagsToElasticSearch\Model\Indexer;

use Magento\Catalog\Api\Data\ProductAttributeInterface;
use Magento\Eav\Model\Config;
use Magento\Eav\Model\Entity\Attribute\AbstractAttribute;

class AttributeCodesProvider
{
    /**
     * @var Config
     */
    private $eavConfig;

    /**
     * @var array
     */
    private $attributeCodes;

    public function __construct(
        Config $eavConfig,
        $attributeCodes = []
    ) {
        $this->eavConfig = $eavConfig;
        $this->attributeCodes = $attributeCodes;
    }

    /**
     * Method provides usable attribute codes
     *
     * @return array
     */
    public function getAttributeCodes(): array
    {
        foreach ($this->attributeCodes as $attributeCode) {
            if (!$this->isSearchable($attributeCode)) {
                unset($this->attributeCodes[$attributeCode]);
            }
        }

        return $this->attributeCodes;
    }

    private function isSearchable(string $attributeCode)
    {
        $attribute = $this->eavConfig->getAttribute(
            ProductAttributeInterface::ENTITY_TYPE_CODE,
            $attributeCode
        );
        return $attribute->getIsSearchable() || $attribute->getIsVisibleInAdvancedSearch();
    }
}
