<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Amasty_MetaTagsToElasticSearch
*/


declare(strict_types=1);

namespace Amasty\MetaTagsToElasticSearch\Model;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Store\Model\ScopeInterface;

class ConfigProvider
{
    private const CONFIG_PATH = 'amasty_elastic/index/enable_meta_indexation';

    /**
     * @var ScopeConfigInterface
     */
    private $scopeConfig;

    public function __construct(ScopeConfigInterface $scopeConfig)
    {
        $this->scopeConfig = $scopeConfig;
    }

    /**
     * Method provides integration configuration enable setting
     *
     * @param int $storeId
     * @return bool
     */
    public function isIntegrationEnabled(int $storeId): bool
    {
        return $this->scopeConfig->isSetFlag(self::CONFIG_PATH, ScopeInterface::SCOPE_STORE, $storeId);
    }
}
