<?php
/**
* @author Amasty Team
* @copyright Copyright (c) 2022 Amasty (https://www.amasty.com)
* @package Loyalty Program for Magento 2
*/

namespace Amasty\RulesLoyalty\Model;

use Amasty\Base\Model\ConfigProviderAbstract;

class ConfigProvider extends ConfigProviderAbstract
{
    /**
     * xpath prefix of module (section)
     *
     * @var string
     */
    protected $pathPrefix = 'amrulesloyalty/';

    public const GENERAL_BLOCK = 'general/';

    public const HEADER = 'descr_header';
    public const DESCRIPTION = 'description';
    public const STATS_HEADER = 'stats_header';

    /**
     * @return string
     */
    public function getHeader()
    {
        return $this->getValue(self::GENERAL_BLOCK . self::HEADER);
    }

    /**
     * @return string
     */
    public function getDescription()
    {
        return (string)$this->getValue(self::GENERAL_BLOCK . self::DESCRIPTION);
    }

    /**
     * @return string
     */
    public function getStatsHeader()
    {
        return $this->getValue(self::GENERAL_BLOCK . self::STATS_HEADER);
    }
}
