<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Google Invisible Captcha Hyva
 */

namespace Amasty\InvisibleCaptchaHyva\Plugin\InvisibleCaptcha\Model\ConfigProvider;

use Amasty\InvisibleCaptcha\Model\ConfigProvider;
use Hyva\Theme\Service\CurrentTheme;

class UpdateFormSelectors
{
    /**
     * @var CurrentTheme
     */
    private CurrentTheme $currentTheme;

    /**
     * @var array{array{originalAction: string, updatedSelector: string}}
     */
    private array $selectorsMap;

    /**
     * @param CurrentTheme $currentTheme
     * @param array{array{originalAction: string, updatedSelector: string}} $selectorsMap
     */
    public function __construct(
        CurrentTheme $currentTheme,
        array $selectorsMap
    ) {
        $this->currentTheme = $currentTheme;
        $this->selectorsMap = $selectorsMap;
    }

    /**
     * @param ConfigProvider $subject
     * @param string[] $formSelectors
     * @return string[]
     *
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function afterGetAllFormSelectors(ConfigProvider $subject, array $formSelectors): array
    {
        if (!$this->currentTheme->isHyva()) {
            return $formSelectors;
        }

        foreach ($formSelectors as &$formSelector) {
            foreach ($this->selectorsMap as $selectorMap) {
                if (strpos($formSelector, $selectorMap['originalAction']) !== false) {
                    $formSelector = $selectorMap['updatedSelector'];
                    break;
                }
            }
        }

        return $formSelectors;
    }
}
