<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Google Invisible Captcha Hyva
 */

namespace Amasty\InvisibleCaptchaHyva\Plugin\Framework\GraphQl\Query;

use Amasty\InvisibleCaptchaHyva\Api\GraphQlCaptchaValidatorInterface;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;

/**
 * Validate ReCaptcha for GraphQl mutations.
 */
class ValidateCaptcha
{
    /**
     * @var GraphQlCaptchaValidatorInterface
     */
    private GraphQlCaptchaValidatorInterface $captchaValidator;

    public function __construct(
        GraphQlCaptchaValidatorInterface $captchaValidator
    ) {
        $this->captchaValidator = $captchaValidator;
    }

    /**
     * Validate ReCaptcha for mutations if needed.
     *
     * @param ResolverInterface $subject
     * @param Field $fieldInfo
     * @param mixed $context
     * @param ResolveInfo $resolveInfo
     * @return void
     *
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function beforeResolve(
        ResolverInterface $subject,
        Field $fieldInfo,
        $context,
        ResolveInfo $resolveInfo
    ): void {
        $this->captchaValidator->performValidation($fieldInfo, $resolveInfo);
    }
}
