<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Instagram Feed GraphQl for Magento 2 (System)
 */

namespace Amasty\InstagramFeedGraphql\Model\Resolver;

use Amasty\InstagramFeed\Model\Config\Source\Sorting;
use Amasty\InstagramFeed\Model\Instagram\IsMainInstagramSettingsDifferent;
use Amasty\InstagramFeedGraphql\Model\Instagram\Post\GetPostsData;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Exception\GraphQlNoSuchEntityException;
use Magento\Framework\GraphQl\Query\Resolver\ContextInterface;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;
use Magento\Store\Model\Store;

class Posts implements ResolverInterface
{
    /**
     * @var GetPostsData
     */
    private $getPostsData;

    /**
     * @var IsMainInstagramSettingsDifferent
     */
    private $isMainInstagramSettingsDifferent;

    public function __construct(
        GetPostsData $getPostsData,
        IsMainInstagramSettingsDifferent $isMainInstagramSettingsDifferent
    ) {
        $this->getPostsData = $getPostsData;
        $this->isMainInstagramSettingsDifferent = $isMainInstagramSettingsDifferent;
    }

    /**
     * @param Field $field
     * @param ContextInterface $context
     * @param ResolveInfo $info
     * @param array|null $value
     * @param array|null $args
     * @return array
     * @throws GraphQlNoSuchEntityException|NoSuchEntityException
     */
    public function resolve(
        Field $field,
        $context,
        ResolveInfo $info,
        array $value = null,
        array $args = null
    ): array {
        $currentStoreId = (int)$context->getExtensionAttributes()->getStore()->getId();
        $storeId = $this->isMainInstagramSettingsDifferent->execute($currentStoreId)
            ? $currentStoreId
            : Store::DEFAULT_STORE_ID;
        $sortId = $args['sortField'] ?? Sorting::NEWEST;

        return $this->getPostsData->execute($sortId, $args['limit'], $args['page'], $storeId);
    }
}
