<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Seo Rich Data Graphql by Amasty
 */

namespace Amasty\SeoRichDataGraphql\Model\Resolver\Product;

use Amasty\SeoRichData\Model\Source\Product\OfferItemCondition as OfferItemConditionSource;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Exception\GraphQlInputException;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;

class OfferItemCondition implements ResolverInterface
{
    public function resolve(
        Field $field,
        $context,
        ResolveInfo $info,
        array $value = null,
        array $args = null
    ): string {
        if (!isset($value['model'])) {
            throw new GraphQlInputException(__('"model" must be specified'));
        }

        $itemConditionValue = $value['model']->hasData($field->getName())
            ? $value['model']->getData($field->getName())
            : OfferItemConditionSource::NEW_CONDITION;

        return (string)$itemConditionValue;
    }
}
