<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Seo Rich Data Graphql by Amasty
 */

namespace Amasty\SeoRichDataGraphql\Model\Resolver;

use Amasty\Base\Model\Serializer;
use Amasty\SeoRichData\Model\JsonLd\ProcessorProvider;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Query\Resolver\ContextInterface;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;

class GetRichSnippets implements ResolverInterface
{
    /**
     * @var ProcessorProvider
     */
    private $processorProvider;

    /**
     * @var Serializer
     */
    private $serializer;

    public function __construct(
        ProcessorProvider $processorProvider,
        Serializer $serializer
    ) {
        $this->processorProvider = $processorProvider;
        $this->serializer = $serializer;
    }

    /**
     * @param Field $field
     * @param ContextInterface $context
     * @param ResolveInfo $info
     * @param array|null $value
     * @param array|null $args
     * @return array
     */
    public function resolve(
        Field $field,
        $context,
        ResolveInfo $info,
        array $value = null,
        array $args = null
    ): array {
        $data = [];
        foreach ($this->processorProvider->getProcessors() as $processor) {
            $data = $processor->process($data);
        }

        $result = [];
        foreach ($data as $key => $section) {
            $result[$key] = "<script type=\"application/ld+json\">{$this->serializer->serialize($section)}</script>";
        }

        return $result;
    }
}
