<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Gift Card Pro Hyva Compatibility
 */
declare(strict_types=1);

namespace Amasty\GiftCardHyvaCompatibility\ViewModel;

use Magento\Framework\App\ProductMetadata;
use Magento\Framework\App\ProductMetadataInterface;
use Magento\Framework\View\Element\Block\ArgumentInterface;

class GraphQlQueries implements ArgumentInterface
{
    /**
     * Get Gift Card Preview
     *
     * @return string
     */
    public function getGiftCardPreview(): string
    {
        return 'amGiftCardPreview(
                    input: {
                        am_giftcard_amount: $amount,
                        am_giftcard_amount_custom: $customAmount,
                        am_giftcard_sender_name: $sender,
                        am_giftcard_recipient_name: $recipient,
                        am_giftcard_message: $message,
                        am_giftcard_image: $image,
                        am_giftcard_custom_image: $customImage,
                        am_giftcard_hyva_flag: $hyvaFlag,
                        am_email_template: $emailTemplate
                    }
                ) {
                    content
                }';
    }
}
