<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Gift Card Pro Hyva Compatibility
 */

declare(strict_types=1);

namespace Amasty\GiftCardHyvaCompatibility\Model;

use Amasty\GiftCard\Api\Data\GiftCardEmailInterfaceFactory;
use Amasty\GiftCard\Api\Data\GiftCardOptionInterface;
use Amasty\GiftCard\Model\ConfigProvider;
use Amasty\GiftCard\Model\Image\Repository;
use Amasty\GiftCard\Utils\FileUpload;
use Magento\Framework\Locale\CurrencyInterface;
use Magento\Framework\Mail\Template\FactoryInterface;
use Magento\Store\Model\StoreManagerInterface;

class EmailPreviewProcessor extends \Amasty\GiftCard\Model\GiftCard\EmailPreviewProcessor
{
    /**
     * Constant defined for data array
     */
    public const HYVA_FLAG = 'am_giftcard_hyva_flag';

    /**
     * @var FileUpload
     */
    private $fileUpload;

    /**
     * @param Repository $imageRepository
     * @param FileUpload $fileUpload
     * @param FactoryInterface $templateFactory
     * @param ConfigProvider $config
     * @param GiftCardEmailInterfaceFactory $cardEmailFactory
     * @param CurrencyInterface $localeCurrency
     * @param StoreManagerInterface $storeManager
     */
    public function __construct(
        Repository $imageRepository,
        FileUpload $fileUpload,
        FactoryInterface $templateFactory,
        ConfigProvider $config,
        GiftCardEmailInterfaceFactory $cardEmailFactory,
        CurrencyInterface $localeCurrency,
        StoreManagerInterface $storeManager
    ) {
        parent::__construct(
            $imageRepository,
            $fileUpload,
            $templateFactory,
            $config,
            $cardEmailFactory,
            $localeCurrency,
            $storeManager
        );
        $this->fileUpload = $fileUpload;
    }

    /**
     * Get Preview Image
     *
     * @param array $requestData
     * @return String
     */
    protected function getPreviewImage(array $requestData): string
    {
        if ($customImage = $requestData[GiftCardOptionInterface::CUSTOM_IMAGE] ?? null) {
            if ($requestData[self::HYVA_FLAG] === 1) {
                return '<img src="' . $customImage . '"/>';
            } else {
                return '<img src="' . $this->fileUpload->getTempImgUrl($customImage) . '"/>';
            }
        }

        return parent::getPreviewImage($requestData);
    }
}
