<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Gift Card Account Hyva Compatibility
 */
declare(strict_types=1);

namespace Amasty\GiftCardAccountHyvaCompatibility\ViewModel;

use Magento\Framework\App\ProductMetadata;
use Magento\Framework\App\ProductMetadataInterface;
use Magento\Framework\View\Element\Block\ArgumentInterface;

class GraphQlQueries implements ArgumentInterface
{
    /**
     * Set Customer Account Gift Card
     *
     * @return string
     */
    public function getAddGiftCardAccount(): string
    {
        return 'addAmGiftCardCodeToAccount(input: { am_giftcard_code: $card }) {
                    message
                    error
                }';
    }

    /**
     * Get Customer Account Gift Card
     *
     * @return string
     */
    public function getRemoveGiftCardAccount(): string
    {
        return 'removeAmGiftCardCodeToAccount(input: { am_giftcard_code: $card }) {
                    message
                    error
                }';
    }

    /**
     * Get Graphql User Gift Card Account
     *
     * @return string
     */
    public function getGiftCardsAccount(): string
    {
        return 'amUserGiftCardAccount {
                    code
                    expiration_date
                    usage
                    status
                    current_balance {
                        value
                        currency
                    }
                }';
    }

    /**
     * Get Graphql Gift Cards Account Check
     *
     * @return string
     */
    public function getGiftCardsAccountCheck(): string
    {
        return 'amGiftCardAccount(input: { am_gift_card_code: $card }) {
                    code
                    expiration_date
                    usage
                    status
                    current_balance {
                        value
                        currency
                    }
                }';
    }

    /**
     * Get Graphql Apply Gift Card To Cart
     *
     * @return string
     */
    public function getApplyAmGiftCardToCart(): string
    {
        return 'applyAmGiftCardToCart(input: { am_gift_card_code: $card, cart_id: $cartId }) {
                    cart {
                        applied_am_gift_cards {
                            code
                            expiration_date
                            current_balance {
                                value
                                currency
                            }
                            applied_balance {
                                value
                                currency
                            }
                        }
                    }

                }';
    }

    /**
     * Get Graphql Remove Gift Card From Cart
     *
     * @return string
     */
    public function removeAmGiftCardFromCart(): string
    {
        return 'removeAmGiftCardFromCart(input: { am_gift_card_code: $card, cart_id: $cartId }) {
                    cart {
                        applied_am_gift_cards {
                            code
                            expiration_date
                            current_balance {
                                value
                                currency
                            }
                            applied_balance {
                                value
                                currency
                            }
                        }
                    }
                }';
    }

    /**
     * Get Applied Gift Card FromCart
     *
     * @return string
     */
    public function getAppliedGiftCardFromCart(): string
    {
        return 'cart(cart_id: $cartId) {
                    applied_am_gift_cards {
                        code
                        expiration_date
                        current_balance {
                            value
                            currency
                        }
                        applied_balance {
                            value
                            currency
                        }
                    }
                }';
    }
}
