<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Gift Card Account Hyva Compatibility
 */

declare(strict_types=1);

namespace Amasty\GiftCardAccountHyvaCompatibility\ViewModel;

use Magento\Framework\View\Element\Block\ArgumentInterface;
use Amasty\GiftCardAccount\Model\GiftCardAccount\GiftCardAccountValidator;
use Magento\Checkout\Model\Session;

class GiftCardAccountViewModal implements ArgumentInterface
{
    /**
     * @var GiftCardAccountValidator
     */
    private $giftCardAccountValidator;

    /**
     * @var Session
     */
    private $checkoutSession;

    /**
     * @param Session $checkoutSession
     * @param GiftCardAccountValidator $giftCardAccountValidator
     */
    public function __construct(
        Session $checkoutSession,
        GiftCardAccountValidator $giftCardAccountValidator
    ) {
        $this->giftCardAccountValidator = $giftCardAccountValidator;
        $this->checkoutSession = $checkoutSession;
    }

    /**
     * Check if Enable Gift Form In Cart
     *
     * @return bool
     * @throws \Magento\Framework\Exception\LocalizedException
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function isEnableGiftFormInCart(): bool
    {
        return $this->giftCardAccountValidator
                ->isGiftCardApplicableToCart($this->checkoutSession->getQuote());
    }
}
