<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Gift Card Account Hyva Compatibility
 */
declare(strict_types=1);

namespace Amasty\GiftCardAccountHyvaCompatibility\Model\Resolver\GiftCardAccount;

use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Exception\GraphQlInputException;
use Magento\Framework\GraphQl\Query\Resolver\ContextInterface;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;
use Amasty\GiftCardAccount\Api\GiftCardAccountRepositoryInterface;
use Amasty\GiftCard\Model\Config\Source\Usage as UseSource;

class Usage implements ResolverInterface
{
    /** @var GiftCardAccountRepositoryInterface */
    private $accountRepository;

    /** @var UseSource */
    private $usage;

    /**
     * Constructor
     *
     * @param GiftCardAccountRepositoryInterface $accountRepository
     * @param UseSource $usage
     */
    public function __construct(
        GiftCardAccountRepositoryInterface $accountRepository,
        UseSource $usage
    ) {
        $this->accountRepository = $accountRepository;
        $this->usage = $usage;
    }

    /**
     * Resolve multiple requests.
     *
     * @param Field $field
     * @param ContextInterface $context
     * @param ResolveInfo $info
     * @param array|null $value
     * @param array|null $args
     * @return string
     * @throws GraphQlInputException
     */
    public function resolve(
        Field $field,
        $context,
        ResolveInfo $info,
        array $value = null,
        array $args = null
    ): string {
        try {
            $account = $this->accountRepository->getByCode($value['code']);
            return (string)$this->usage->getValueByKey($account->getUsage());
        } catch (LocalizedException $e) {
            throw new GraphQlInputException(__($e->getMessage()), $e);
        }
    }
}
