define([
    'uiComponent',
    'jquery',
    'Magento_Ui/js/modal/confirm',
    'mage/translate',
    'uiRegistry',
    'Amasty_GiftCardAccount/js/model/account/codes/messages',
    'Amasty_GiftCardPremiumFunctionality/js/action/account-gift-code-actions'
], function (Component, $, confirm, $t, registry, messageContainer, giftCodeActions) {
    'use strict';

    return Component.extend({
        defaults: {
            template: 'Amasty_GiftCardPremiumFunctionality/account/codes/buttons/redeem',
            confirmMsg: $t('Are you sure you want to redeem?'),
            redeemCardUrl: ''
        },

        redeemGiftCode: function (code) {
            let url = this.redeemCardUrl + 'am_giftcard_code/' + code,
                giftcardProvider = registry.get('amcard-giftcards'),
                self = this;

            confirm({
                content: self.confirmMsg,
                actions: {
                    confirm: function () {
                        giftCodeActions.redeem(url).done(function (response) {
                            if (!response.error) {
                                giftcardProvider.updateCard(response.data);
                                messageContainer.addSuccessMessage({message: response.message});
                                return;
                            }

                            messageContainer.addErrorMessage({message: response.message});
                        }.bind(self));
                    }
                }
            });
        }
    });
});
