/**
 * Account gift cards
 */
define([
    'uiComponent',
    'uiRegistry',
    'mage/translate',
    'Amasty_GiftCardAccount/js/model/account/cards/messages',
    'Amasty_GiftCardPremiumFunctionality/js/action/account-gift-code-actions'
], function (Component, registry, $t, messageContainer, giftCodeActions) {
    'use strict';

    return Component.extend({
        defaults: {
            template: 'Amasty_GiftCardPremiumFunctionality/account/cards/redeem-button',
            redeemCardUrl: '',
            emptyFieldText: $t('Please, enter a valid Gift Card code to redeem.'),
        },

        redeemGiftCode: function () {
            let giftcardProvider = registry.get('amcard-giftcards'),
                code = giftcardProvider.cardCode(),
                url = this.redeemCardUrl + 'am_giftcard_code/' + code;

            if (!code) {
                messageContainer.addErrorMessage({message: this.emptyFieldText});
                return;
            }

            giftCodeActions.redeem(url).done(function (response) {
                if (response.error) {
                    messageContainer.addErrorMessage({message: response.message});
                } else {
                    messageContainer.addSuccessMessage({message: response.message});
                    giftcardProvider.updateCard(response.data);
                }

                giftcardProvider.cardCode('');
            }.bind(this));
        }
    });
});
